

<?php $__env->startSection('title', 'Edit Profile'); ?>

<?php $__env->startSection('content'); ?>
<div class="profile-container">
    <div class="profile-content">
        <div class="profile-section">
            <div class="info-card">
                <form action="<?php echo e(route('profile.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                    
                    <!-- Banner Upload -->
                    <div class="form-group">
                        <label for="banner">Profile Banner</label>
                        
                        <div class="banner-preview">
                            <?php if($user->banner): ?>
                                <img src="<?php echo e(Storage::url('user_banners/' . $user->banner)); ?>" alt="Current Banner" class="current-banner-img">
                                <div class="banner-actions">
                                    <a href="<?php echo e(route('profile.delete-banner')); ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to remove your banner?')">
                                        <i class="fas fa-trash"></i> Remove Banner
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="no-banner">
                                    <i class="fas fa-image"></i>
                                    <p>No banner image set</p>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <input type="file" name="banner" id="banner" class="form-control mt-3 <?php $__errorArgs = ['banner'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        
                        <?php $__errorArgs = ['banner'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        
                        <small class="form-text text-muted">Recommended size: 1200×300px. Maximum size: 2MB. Supported formats: JPG, PNG, GIF.</small>
                    </div>
                    
                    <!-- Name -->
                    <div class="form-group">
                        <label for="name">Display Name</label>
                        <input type="text" name="name" id="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               value="<?php echo e(old('name', $user->name)); ?>">
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <!-- Slug -->
                    <div class="form-group">
                        <label for="slug">Profile Slug</label>
                        <input type="text" name="slug" id="slug" class="form-control <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               value="<?php echo e(old('slug', $user->slug)); ?>">
                        <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <small class="form-text text-muted">This will be used in your profile URL: <?php echo e(config_value('site_url', 'example.com')); ?>/users/your-slug</small>
                    </div>
                    
                    <!-- Avatar Info -->
                    <div class="form-info">
                        <div class="avatar-preview">
                            <img src="<?php echo e($user->avatar); ?>" alt="Avatar" class="avatar-image">
                        </div>
                        <div class="avatar-info">
                            <p>Your avatar is synced with your Steam profile. To change it, update your Steam profile.</p>
                            <a href="<?php echo e($user->getSteamProfileUrl()); ?>" target="_blank" class="steam-link">
                                <i class="fab fa-steam"></i> Go to Steam Profile
                            </a>
                        </div>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Save Changes
                        </button>
                        <a href="<?php echo e(route('profile.show')); ?>" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Preview banner image before upload
        const bannerInput = document.getElementById('banner');
        if (bannerInput) {
            bannerInput.addEventListener('change', function() {
                if (this.files && this.files[0]) {
                    const reader = new FileReader();
                    
                    reader.onload = function(e) {
                        let bannerPreview = document.querySelector('.banner-preview');
                        
                        // Clear the current content
                        bannerPreview.innerHTML = `
                            <img src="${e.target.result}" alt="Banner Preview" class="current-banner-img">
                            <div class="banner-actions">
                                <span class="text-muted">Preview - Save to confirm</span>
                            </div>
                        `;
                    }
                    
                    reader.readAsDataURL(this.files[0]);
                }
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/users/edit.blade.php ENDPATH**/ ?>